
// get parameters from url
const queryString = window.location.search;
const urlParams = new URLSearchParams(queryString);
var cid = urlParams.get('id');
var polling = urlParams.get('poll');
var currentPage = window.location.pathname;
currentPage = currentPage.substring( currentPage.lastIndexOf( '/' ) + 1 );
currentPageRaw = currentPage.substring( 0, currentPage.lastIndexOf( '.php' ) );

// console.log(' href => ' + window.location.href);
// console.log(' host => ' + window.location.host);
// console.log(' hostname => ' + window.location.hostname);
// console.log(' port => ' + window.location.port);
// console.log(' protocol => ' + window.location.protocol);
// console.log(' pathname => ' + window.location.pathname);
// console.log(' hashpathname => ' + window.location.hash);
// console.log(' search=> ' + window.location.search);
// console.log( currentPage );

var init = true;

/* Settings you might want to define */
var waittime=1000;


var xmlhttp = false;
var xmlhttp2 = false;

// if datestring s is today, show the time, else show the date
function dateFormat( s ) {
  var today = new Date();
  var timeOffset = today.getTimezoneOffset();
  timeOffset = parseInt( timeOffset ) / 60;
  var dateStr = s.substr( 0, 10 );
  var result = dateStr; // default time, show date
  var tHour = s.substr( 11, 2 );
  //tHour = parseInt( tHour ) + timeOffset; // depend on timezone!
  tHour = parseInt( tHour ) + 1;
  var tMinute = s.substr( 14, 2 )
  var tSecond = s.substr( 17, 2 );
  var timeStr = ( tHour < 10 ? '0' + tHour : tHour ) + ':' + tMinute + ':' + tSecond;
  //var timeStr = s.substr( 11, 8 );
  var tDay = today.getDate();
  var tMonth = today.getMonth() +1;
  var tYear = today.getFullYear();
  var dateStrNow = ( tYear < 10 ? '0' + tYear : tYear ) + '-' + ( tMonth < 10 ? '0' + tMonth : tMonth ) + '-' + ( tDay < 10 ? '0' + tDay : tDay );
  if( dateStrNow == dateStr ) {
    result = timeStr; // set to time if we are on the same day
  }
  return result;
}

function nameFormat( nameObject ) {
  // online Usersnames should be styleable by class online
  var result = nameObject.users_id;
  if( nameObject.online == 1 ) {
    result = '<span class="online">' + result + '</span>';
  }
  return result
}

function buildEntry( item, index ) {
  var newName = nameFormat( item );
  var newTime = dateFormat( item.created );
  var result = "<tr>";
  result += "<td <td class='cdate'>" + newTime + "</td>";
  result += "<td <td class='cname'>" + newName + "</td>";
  result += "<td <td class='ctext'>" + item.text + "</td>";
  result += "</tr>";
  return result;
}

/* Request for Reading the Chat Content */
function ajax_read( url ) {
  if( window.XMLHttpRequest ) {
    xmlhttp = new XMLHttpRequest();
    if( xmlhttp.overrideMimeType ) {
      xmlhttp.overrideMimeType( 'text/xml' );
    }
  } else if( window.ActiveXObject ) {
    try{
      xmlhttp = new ActiveXObject( "Msxml2.XMLHTTP" );
    } catch( e ) {
      try{
        xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
      } catch( e ){
      }
    }
  }

  if( ! xmlhttp ) {
    alert( 'Giving up :( Cannot create an XMLHTTP instance' );
    return false;
  }

  xmlhttp.onreadystatechange = function() {
    if( xmlhttp.readyState == 4 ) {
      //intUpdate = setTimeout( "ajax_read('y.php?c=" + cid + "&t=" + Math.floor( Date.now() / 1 ) + "')", waittime );
      intUpdate = setTimeout( "ajax_read('api.php?c=" + cid + "&t=" + Math.floor( Date.now() / 1 ) + "')", waittime );
      var response = JSON.parse( xmlhttp.responseText );
      if( response != null ) {
        
        if( init ) {
          // instert all
          var result = '<table id="chatTable" class="">'; // class="table"
          for( i = 0; i < response.length; i++ ) {
            result += buildEntry( response[ i ], i );
          }
          result += '</table>';
          document.getElementById( "chatWrap" ).innerHTML = result;
          init = false;
          $('#chatWrap').animate({ scrollTop: $(document).height() }, "fast");
        } else {
          // apend all new elements
          for( i = 0; i < response.length; i++ ) {
            var table = document.getElementById( 'chatTable' );
            var tableBody = table.getElementsByTagName( 'tbody' );
            
            // if no table body is present
            if( tableBody[0] == undefined ) {
              var tableRows = 0;
            } else {
              var tableRows = tableBody[0].childElementCount;
            }
            
            var newName = nameFormat( response[i] );
            var newTime = dateFormat( response[i].created );
            
            var newRow = table.insertRow( tableRows );
            var row0 = newRow.insertCell( 0 ); // created
            var row1 = newRow.insertCell( 1 ); // users_id
            var row2 = newRow.insertCell( 2 ); // text
            row0.innerHTML = newTime;
            row1.innerHTML = newName;
            row2.innerHTML = response[i].text;
          }

          $('#chatWrap').animate({ scrollTop: $(document).height() }, "fast"); // scroll chat down
        }
        
      }
    }
  }

  xmlhttp.open( 'GET', url, true );
  // xmlhttp.open( 'POST', url, true );
  // xmlhttp.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
  // xmlhttp.onreadystatechange = function() {
      // if(xmlhttp.readyState == 4 && xmlhttp.status == 200) {
      //     alert(xmlhttp.responseText);
      // }
  // }
  xmlhttp.send( null );
}

/* Request for Writing the Message */
function ajax_write( url, params ) {
  if( window.XMLHttpRequest ) {
    xmlhttp2 = new XMLHttpRequest();
    if( xmlhttp2.overrideMimeType ) {
      xmlhttp2.overrideMimeType( 'text/xml' );
    }
  } else if( window.ActiveXObject ){
    try{
      xmlhttp2 = new ActiveXObject( "Msxml2.XMLHTTP" );
    } catch( e ) {
      try{
        xmlhttp2 = new ActiveXObject( "Microsoft.XMLHTTP" );
      } catch( e ){
      }
    }
  }

  if( ! xmlhttp2 ) {
    alert( 'Giving up :( Cannot create an XMLHTTP instance' );
    return false;
  }

  xmlhttp2.open( 'GET', url + '?' + params, true );
  xmlhttp2.send( null );
  // xmlhttp2.open( 'POST', url, true );
  // //Send the proper header information along with the request
  // xmlhttp2.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
  // xmlhttp2.onreadystatechange = function() {//Call a function when the state changes.
  //     // if(xmlhttp2.readyState == 4 && xmlhttp2.status == 200) {
  //     //     alert(xmlhttp2.responseText);
  //     // }
  // }
  // xmlhttp2.send( params );
}

/* Submit the Message */
function submit_msg(){
  nick = document.getElementById( "chatnick" ).value;
  msg = document.getElementById( "chatmsg" ).value;

  if( nick == "" ) {
    check = prompt( "please enter username:" );
    if( check === null ) return 0;
    if( check == "" ) check = "anonymous";
    document.getElementById( "chatnick" ).value = check;
    nick = check;
  }

  document.getElementById( "chatmsg" ).value = ""; // empty inputfield
  //ajax_write( "x.php?c=" + cid + "&u=" + uid + "&t=" + msg );
  ajax_write( "api.php", "c=" + cid + "&u=" + uid + "&msg=" + msg );
}




function notifyMe() {
  // Let's check if the browser supports notifications
  if (!("Notification" in window)) {
    alert("This browser does not support desktop notification");
  }

  // Let's check whether notification permissions have alredy been granted
  else if (Notification.permission === "granted") {
    // If it's okay let's create a notification
    var notification = new Notification("Hi there!");
  }

  // Otherwise, we need to ask the user for permission
  else if (Notification.permission !== 'denied') {
    Notification.requestPermission(function (permission) {
      // If the user accepts, let's create a notification
      if (permission === "granted") {
        var notification = new Notification("Hi there!");
      }
    });
  }

  // At last, if the user has denied notifications, and you 
  // want to be respectful there is no need to bother them any more.
}

function notifyBtn() {
  var title = '';
  if( Notification.permission === "granted" ) {
    title += 'Un notify me!';
  } else {
    title += 'Notify me!';
  }
  return '<button onclick="notifyMe()">' + title + '</button>';
}

/* document ready */
document.addEventListener("DOMContentLoaded", function( event ) {
  
  if( cid != undefined && polling != undefined ) {
    var chatwrap = document.getElementById( "chatWrap" );
    if( chatwrap != undefined ) {
      chatwrap.innerHTML = "loading...";
    }
//    var intUpdate = setTimeout("ajax_read( 'y.php?c="+cid+"')", 1000 );
//    var intUpdate = setTimeout("ajax_read('y.php?c=" + cid + "&t=" + Math.floor( Date.now() / 1000 ) + "')", 1000 );
  }

  // set focus to inputfields
  var chatmsg = document.getElementById( "chatmsg" );
  if( chatmsg != undefined ) {
    //chatmsg.addEventListener("focus", function() { this.select(); }); // select all
    chatmsg.focus()
  }

  var username = document.getElementById( "name" );
  if( username != undefined ) {
    username.addEventListener("focus", function() { this.select(); }); // select all
    username.focus();
  } 

  if( currentPageRaw === '' || currentPage === 'index.php' ) {
    /* Show Loading Text */
    var chatwrap = document.getElementById( "chatWrap" );
    if( chatwrap != undefined ) {
      chatwrap.innerHTML = "loading...";
    }
    if( cid != undefined && polling != undefined ) {
      // init Polling (send only a channel id and no time)
      //var intUpdate = setTimeout( "ajax_read( 'y.php?c=" + cid + "')", 1000 );
      var intUpdate = setTimeout( "ajax_read( 'api.php?c=" + cid + "')", 1000 );
    }
  } 
 
 
});

/* Check if Enter is pressed on Chatspage */
function keyup( arg1 ) {
  if( arg1 == 13 && polling == 1 && currentPageRaw === '' || currentPage === 'index.php' ) {
    submit_msg();
  }
}
